/*
 * Created on Sep 10, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package DatabaseCommunication;
import JavaBeans.*;

import java.sql.*;
import java.util.*;
import java.io.*;
/**
 * @author student
 *
 * This class is being used for communicating with the application database
 * relating to information relevant to Coffee.
 * 
 */
public class CoffeeManager {
	private Connection con;

	/**
	 * This is the contructor for CoffeeManager.java
	 * This class manages communication with the application database 
	 * that is related to coffees. 
	 */
	public CoffeeManager() {
		try {
			Properties p = new Properties();
			p.load(new FileInputStream("coffee.txt"));
			String url = p.getProperty("MYSQLURL");
			//String url = "jdbc:mysql://172.21.5.26:3306/coffee";
			System.out.println("MYSQLURL " + url);
			Class.forName("com.mysql.jdbc.Driver").newInstance();
			con = DriverManager.getConnection(url, "root", "password");
			System.out.println(
				"Now connected to the Coffee database from Stock manager.");
		} catch (Exception e) {
			System.out.println(
				"Coffee Manager constructor exception : " + e.toString());

		}

	}
	/**
	 * This method is being used for obtaining all the coffee types
	 * existing in the application database.
	 * @return Coffee_Data[] All the coffee data that is stored in the application
	 * database.
	 */
	public Coffee_Data[] readAllCoffees() {
		try {
			Coffee_Data[] coffees = new Coffee_Data[15];
			String query = "SELECT * FROM coffee;";
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery(query);

			for (int i = 0; i < 15; i++) {
				rs.next();
				double d = Double.valueOf(rs.getString(4)).doubleValue();
				Coffee_Data temp =
					new Coffee_Data(
						rs.getString(1),
						rs.getString(2),
						rs.getString(3),
						d,
						rs.getString(5));
				coffees[i] = temp;
			}

			return coffees;
		} catch (Exception e) {
			System.out.println("Database Exception : " + e.toString());
			return null;
		}
	}
}
